package gov.va.med.mhv.usermgmt.data.repository;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.data.model.Patient;

public interface PatientRepository extends JpaRepository<Patient, Long> {

	@Query("select patient from Patient patient where patient.userProfile.id = :userProfileid")
	public Patient getPatientByUserProfileIdSingle(@Param("userProfileid") Long userProfileid);
	
	@Query("select patient from Patient patient where patient.userProfile.id = :userProfileid")
	public List<Patient> getPatientByUserProfileId(@Param("userProfileid") Long userProfileid);

	@Query("select patient from Patient patient where patient.icn = :icn")
	public List<Patient> getPatientByIcn(@Param("icn") String icn);
	
	@Query("select count(patient) from Patient patient where patient.icn = :icn")
	Long getPatientCountByIcn(@Param("icn") String icn);

	@Query("select patient from Patient patient where lower(patient.icn) = :icn")
	public List<Patient> getPatientByPartialIcn(@Param("icn") String icn);

	@Query("select p from Patient p, UserProfile u "+
		   "where u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
		   "and p.matchedDateTime is not null "+
		   "and p.userProfileId = u.id " +
		   "and (u.deactivationDescriptionText is null or u.deactivationDescriptionText != 'Account inactive for more than 26 months') " +
		   "and (p.correlationStatus = 0 or p.correlationStatus = 7)")
	public Page<Patient> getMatchedUncorrelatedPatients(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u "+
			   "where u.lastName not like '%DELETED' "+
			   "and u.lastName not like '%Deleted' "+
			   "and u.lastName not like '%DECEASED' "+
			   "and u.lastName not like '%Deceased' "+
			   "and p.matchedDateTime is not null "+
			   "and p.userProfileId = u.id " +
			   "and rownum < 10 " +
			   "and (p.correlationStatus = 0 or p.correlationStatus = 7)")
	public Page<Patient> getMatchedUncorrelatedPatientsTest(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u "+
			   "where ((u.firstName is null "+
			   "or u.lastName is null "+
				"or u.birthDate is null "+
				"or u.ssn is null "+
				"or u.gender is null) or "+
				"(u.firstName ='' "+
				"or u.lastName ='' "+
				"or u.birthDate ='' "+
				"or u.ssn ='' "+
				"or u.gender = '')) "+
				"and u.addressCountry is not null "+
				"and u.addressCountry != 'Korea, South' "+
				"and u.addressCountry != 'Virgin Islands, British' "+
				"and u.lastName not like '%DELETED' "+
				"and u.lastName not like '%Deleted' "+
				"and u.lastName not like '%DECEASED' " +
				"and u.lastName not like '%Deceased' "+
				"and p.userProfileId = u.id " +
				"and p.icn like '%V%'")
	public Page<Patient> getRequiredFieldEmpty(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u "+
			"where (u.firstName is not null "+
			"or u.lastName is not null "+
			"or u.birthDate is not null "+
			"or u.ssn is not null "+
			"or u.gender is not null) "+
			"and (u.isVeteran = 1 or u.isPatient = 1) "+
			"and u.addressCountry is not null "+
			"and u.addressCountry != 'Korea, South' "+
			"and u.addressCountry != 'Virgin Islands, British' "+
			"and p.matchedDateTime is null "+
			"and u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
			"and p.userProfileId = u.id " +
			"and p.icn is not null " +
			"and p.icn like '%V%'")
	public Page<Patient> getRecordsNotMatchedToMVI(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u "+
			"where (u.firstName is not null "+
			"or u.lastName is not null "+
			"or u.birthDate is not null "+
			"or u.ssn is not null "+
			"or u.gender is not null) "+
			"and (u.isVeteran = 1 or u.isPatient = 1) "+
			"and u.addressCountry is not null "+
			"and u.addressCountry != 'Korea, South' "+
			"and u.addressCountry != 'Virgin Islands, British' "+
			"and p.matchedDateTime is null "+
			"and u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
			"and p.userProfileId = u.id " +
			"and p.icn is not null " +
			"and p.icn like '%V%' " +
			"and rownum < 10")
	public Page<Patient> getRecordsNotMatchedToMVITest(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u where  "+
    	    "p.icn is not null "+
			"and p.icn like '%V%' " +
    		"and u.addressCountry is not null "+
    		"and u.addressCountry != 'Korea, South' "+
			"and u.addressCountry != 'Virgin Islands, British' "+
    		"and u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
			"and p.userProfileId = u.id " +
    		"and (u.isVeteran = 1 or u.isPatient = 1)")
	public Page<Patient> getRecordsMHVMVIMisMatch(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u where  "+
	    	  "p.icn is not null "+
	    	   "and p.icn like '%V%' " +
	    		"and u.addressCountry is not null "+
	    		"and u.addressCountry != 'Korea, South' "+
				"and u.addressCountry != 'Virgin Islands, British' "+
	    		"and u.lastName not like '%DELETED' "+
				"and u.lastName not like '%Deleted' "+
				"and u.lastName not like '%DECEASED' "+
				"and u.lastName not like '%Deceased' "+
	    		"and (u.isVeteran = 1 or u.isPatient = 1) " +
				"and u.id = p.userProfileId " +
	    		"and rownum < 10")
	public Page<Patient> getRecordsMHVMVIMisMatchTest(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u where  "+
    	    "p.icn is null "+
    		"and u.addressCountry is not null "+
    		"and u.addressCountry != 'Korea, South' "+
			"and u.addressCountry != 'Virgin Islands, British' "+
    		"and u.lastName not like '%DELETED' "+
			"and u.lastName not like '%Deleted' "+
			"and u.lastName not like '%DECEASED' "+
			"and u.lastName not like '%Deceased' "+
			"and p.userProfileId = u.id " +
    		"and (u.isVeteran = 1 or u.isPatient = 1)")
	public Page<Patient> getRecordsMHVIcnMissing(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u where  "+
	    	  "p.icn is null "+
	    		"and u.addressCountry is not null "+
	    		"and u.addressCountry != 'Korea, South' "+
				"and u.addressCountry != 'Virgin Islands, British' "+
	    		"and u.lastName not like '%DELETED' "+
				"and u.lastName not like '%Deleted' "+
				"and u.lastName not like '%DECEASED' "+
				"and u.lastName not like '%Deceased' "+
	    		"and (u.isVeteran = 1 or u.isPatient = 1) " +
				"and u.id = p.userProfileId " +
	    		"and rownum < 10")
	public Page<Patient> getRecordsMHVIcnMissingTest(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u "+ 
            "where u.id = p.userProfileId "+ 
            "and u.deactivationCode is not null "+
            "and u.deactivationDescriptionText is not null "+
            "and u.deactivationAdmin is not null "+
            "and u.deactivationDateTime is not null "+ 
            "and upper(u.lastName) like '%DELETED' "+
            "and p.icn like '%A%' "+
            "and u.id = 36062")
	public Page<Patient> getAccountDeactivationFix(Pageable pageRequest);

	@Transactional
	@Procedure("MHV_VAR_ELIGIBILITY")
	 public int varEligibleCheck(Long patientid);

	@Query("select p from Patient p, UserProfile u where " +
			"p.icn is not null " +
			"and p.icn like '%V%' " +
			"and (u.createdDate is not null or u.lastLogin is not null) " +
			"and u.lastName not like '%DECEASED' " +
			"and u.lastName not like '%Deceased' " +
			"and u.lastName not like '%DELETED%' " +
			"and u.lastName not like '%Deleted%' " +
			"and u.deactivationDateTime is null " +
			"and p.userProfileId = u.id")
	public List<Patient> getAutoDeactivationList();

	@Query("select p from Patient p, UserProfile u where " +
			"p.icn is not null " +
			"and p.icn like '%V%' " +
			"and (p.userProfileId = 10508892" +
			"or p.userProfileId = 10532936" +
			"or p.userProfileId = 10565182" +
			"or p.userProfileId = 10533117" +
			"or p.userProfileId = 10526288" +
			"or p.userProfileId = 10719279" +
			"or p.userProfileId = 10719291" +
			"or p.userProfileId = 10719287)" +
			"and u.lastName not like '%DELETED%' " +
			"and u.lastName not like '%Deleted%' " +
			"and u.deactivationDateTime is null " +
			"and p.userProfileId = u.id")
	public List<Patient> getAutoDeactivationListTest();

	@Query("select p from Patient p, UserProfile u where " +
			"p.userProfileId = u.id " +
			"and u.lastName like :lastName")
	public List<Patient> getAutoDeactivationListLastName(@Param("lastName") String lastName);

	@Query("select p from Patient p, UserProfile u "
			+ "where p.userProfileId = u.id "
			+ "and (SYSDATE - :daysSinceCreation) > u.createdDate "
			+ "and upper(u.lastName) not like '%DELETED' "
			+ "and u.deactivationDateTime is null "
			+ "and p.icn like '%V%' "
			+ "and u.id = 36062")  // TODO: Look at this and see if it's correct to include this parameter
	public Page<Patient> getPatientListCreatedBefore(@Param("daysSinceCreation")int daysSinceCreation, Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u "
			+ "where p.userProfileId = u.id "
			+ "and (SYSDATE - :daysSinceCreation) > u.createdDate "
			+ "and upper(u.lastName) not like '%DELETED' "
			+ "and u.deactivationDateTime is null "
			+ "and p.userProfileId = 1058892")  // TODO: Look at this and see if it's correct to include this parameter
	public Page<Patient> getPatientListCreatedBeforeTest(@Param("daysSinceCreation")int daysSinceCreation, Pageable pageRequest);

	//@Query("select s.emailAddress from SMS_SRE.SMSUSER s where " +
	//		"s.ssn = :ssn")
	//public String getAutoDeactivationListSMSUser(@Param("SSN") String ssn);
	
	@Query("select p from Patient p, UserProfile u "+
			   "where UPPER(u.lastName) not like '%DELETED%' "+
			   "and UPPER(u.lastName) not like '%DECEASED%' "+
			   "and p.matchedDateTime is not null "+
			   "and p.icn like '%V%' " +
			   "and p.userProfileId = u.id " +
			   "and (p.correlationStatus = 4 or p.correlationStatus = 5 or p.correlationStatus = 6)")
	public Page<Patient> getFailedCorrelation(Pageable pageRequest);

	@Query("select p from Patient p, UserProfile u "+
			   "where UPPER(u.lastName) not like '%DELETED%' "+
			   "and UPPER(u.lastName) not like '%DECEASED%' "+
			   "and p.matchedDateTime is not null "+
			   "and p.userProfileId = u.id " +
			   "and p.icn like '%V%' " +
			   "and (p.correlationStatus = 4 or p.correlationStatus = 5 or p.correlationStatus = 6) " +
			   "and p.userProfileId = 284095")
	public Page<Patient> getFailedCorrelationTest(Pageable pageRequest);

}